<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Log;
use App\Models\User;
use Session;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    protected $redirectTo = '/home';


    public function index()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {

        $this->validate($request, [
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        $username = $request->input('username');
        $domain = explode('@', $username)[1];
        // dd($domain);
        $connectionName = DB::connection('mysql')
            ->table('repositories')
            ->where('domain', $domain)
            ->value('db_name');

        if ($connectionName) {

            config(['database.default' => $connectionName]);
            DB::purge();
            DB::reconnect($connectionName);
        } else {
            return back()->withErrors('Invalid domain');
        }

        $credentials = $request->only(['username', 'password']);


        if (Auth::attempt(['username' => $credentials['username'], 'password' => $credentials['password']])) {
            session(['db_conn' => $connectionName]);
            return redirect('/dashboard');
        } else {
            return $this->sendFailedLoginResponse($request);
        }
    }

    public function logout(Request $request)
    {
        $connectionName = session('db_conn');

        config(['database.default' => $connectionName]);
        DB::reconnect($connectionName);

        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('login'); // Redirect to login page
    }



    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
}
