<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ProofficeInventory;
use App\Models\ProviewInventory;
use App\Models\ProofficeStatus;
use App\Models\Proviewstatus;

class DashboardController extends Controller
{
    public function index()
    {
        // Get the current database connection from the session
        $connectionName = session('db_conn', 'mysql'); // Default to 'mysql' if not set

        // Fetch data based on the current database connection
        $totalQuantity = 0;
        // $totalQuantityProview = 0;
        $inUseProoffice = 0;
        $storeProoffice = 0;
        $damagedProoffice = 0;
        $lostProoffice = 0;
        $inUseProview = 0;
        $storeProview = 0;
        $damagedProview = 0;
        $lostProview = 0;
        $companyName = '';

        if ($connectionName == 'prooffice') {
            // Use Prooffice database
            DB::setDefaultConnection('prooffice');
            $companyName = 'Prooffice Sdn Bhd';
            $totalQuantity = ProofficeInventory::sum('TotalQuantity');
            $inUseProoffice = ProofficeStatus::where('status', 'In Use/Active')->count();
            $damagedProoffice = ProofficeStatus::where('status', 'damaged')->count();
            $lostProoffice = ProofficeStatus::where('status', 'lost/Not Found')->count();
        } elseif ($connectionName == 'proview') {
            // Use Proview database
            DB::setDefaultConnection('proview');
            $companyName = 'Proview Sdn Bhd';
            $totalQuantity = ProviewInventory::sum('TotalQuantity');
            $inUseProview = Proviewstatus::where('status', 'In Use/Active')->count();
            $damagedProview = Proviewstatus::where('status', 'damaged')->count();
            $lostProview = Proviewstatus::where('status', 'lost/Not Found')->count();
        }

        // Calculate the total asset value and status counts
        // $totalAssetValue = $totalQuantityProoffice + $totalQuantityProview;
        $inUse = $inUseProoffice + $inUseProview;
        $store = $storeProoffice + $storeProview;
        $damaged = $damagedProoffice + $damagedProview;
        $lost = $lostProoffice + $lostProview;

        // Pass the data to the view
        return view('dashboard', [
            // 'totalAssetValue' => $totalAssetValue,
            // 'totalQuantityProoffice' => $totalQuantityProoffice,
            'totalQuantity' => $totalQuantity,
            'inUse' => $inUse,
            'damaged' => $damaged,
            'lost' => $lost,
            'inUseProoffice' => $inUseProoffice,
            'storeProoffice' => $storeProoffice,
            'damagedProoffice' => $damagedProoffice,
            'lostProoffice' => $lostProoffice,
            'inUseProview' => $inUseProview,
            'storeProview' => $storeProview,
            'damagedProview' => $damagedProview,
            'lostProview' => $lostProview,
            'companyName' => $companyName,
        ]);
    }
}
