<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;

class Serial extends Model
{
    use HasFactory;
    protected $table = 'serials';
    protected $fillable = [
        'serialNo',
        'tagNumber',
        'holder',
        'status',
        'inventory_id',
        'location_id'
    ];

    public function inventory()
    {
        return $this->belongsTo(Inventory::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function images(): HasMany
    {
        return $this->hasMany(Image::class, 'serial_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($serial) {
            $serial->images->each->delete();
        });
    }
}
