@extends('layouts.app')

@section('content')
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                            class="feather icon-home"></i></a></li>
                                                <li class="breadcrumb-item"><a href="#">Category</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            {{-- Sub-category table --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row mb-3">
                                            {{-- Search input --}}
                                            <div class="col-sm-4">
                                                <input type="text" id="searchInput" class="form-control"
                                                    placeholder="Search sub-categories" onkeyup="searchTable()">
                                            </div>
                                            <div class="col-sm-8 text-right">
                                                <button type="button" class="btn btn-primary btn-rounded"
                                                    data-toggle="modal" data-target="#addCategoryModal">
                                                    Add Category
                                                </button>
                                            </div>
                                        </div>

                                        @if ($message = Session::get('success'))
                                            <div class="alert alert-success" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($message = Session::get('error'))
                                            <div class="alert alert-danger" role="alert">
                                                {{ $message }}
                                            </div>
                                        @endif

                                        @if ($errors->any())
                                            <div class="alert alert-danger" role="alert">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <div class="dt-responsive table-responsive">
                                            <table id="subCategoryTable" class="table table-striped table-bordered nowrap">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">No.</th>
                                                        <th>Sub-Category</th>
                                                        <th>Code</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php
                                                        $counter = 1;
                                                    @endphp
                                                    @foreach ($categories as $category)
                                                        <tr>
                                                            <td class="col-1 text-center">{{ $counter++ }}</td>
                                                            <td>{{ $category->name }}</td>
                                                            <td>{{ $category->code }}</td>
                                                            <td class="col-1 text-center">
                                                                <a href="{{ route('category.edit', $category->id) }}">
                                                                    <i class="feather icon-edit"></i>-Edit
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <!-- Add Category Modal -->
                                    <div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog"
                                        aria-labelledby="addCategoryModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="addCategoryModalLabel">Add New Category</h5>
                                                    <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <form action="{{ route('category.store') }}" method="POST">
                                                        @csrf
                                                        <div class="form-group">
                                                            <label for="categoryName">New Category</label>
                                                            <input type="text" class="form-control" id="categoryName"
                                                                name="name" placeholder="Category Name" required>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="categoryCode">Category Code</label>
                                                            <input type="text" class="form-control" id="categoryCode"
                                                                name="code" placeholder="Category Code" required>
                                                        </div>
                                                        <button type="submit" class="btn btn-primary">Submit</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- End of Add Category Modal -->
                                </div>
                            </div>
                            {{-- End of sub-category table --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        function searchTable() {
            // Declare variables
            var input, filter, table, tr, td, i, txtValue;
            input = document.getElementById("searchInput");
            filter = input.value.toUpperCase();
            table = document.getElementById("subCategoryTable");
            tr = table.getElementsByTagName("tr");

            // Loop through all table rows, and hide those who don't match the search query
            for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1]; // Index 1 corresponds to Sub-Category name
                if (td) {
                    txtValue = td.textContent || td.innerText;
                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                        tr[i].style.display = "";
                    } else {
                        tr[i].style.display = "none";
                    }
                }
            }
        }
    </script>
@endsection
