@extends('layouts.app')

@section('content')
    <?php

    ?>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                            class="feather icon-home"></i></a></li>

                                                <li class="breadcrumb-item"><a href="">Inventory</a></li>

                                                <li class="breadcrumb-item"><a
                                                        href="">{{ $inventories->category->name }}</a>
                                                </li>
                                                <li class="breadcrumb-item"><a href="">{{ $inventoryName }}</a></li>

                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            {{-- card inventory info start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-9">
                                                <h5>{{ $inventoryName }}</h5>
                                            </div>
                                            <div class="col-1.5">
                                                <form action="{{ route('inventory.destroy', ['id' => $inventories->id]) }}"
                                                    method="POST" id="deleteForm">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="btn btn-danger btn-sm"
                                                        onclick="confirmDelete()">
                                                        <i class="feather icon-slash"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                            <div class="col-1.5">
                                                <a href="{{ route('inventory.edit', ['id' => $inventories->id]) }}"
                                                    class="btn btn-primary btn-sm">
                                                    <i class="feather icon-edit"></i> Edit
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-body task-details" style="">
                                            <table class="table" style="table-layout: fixed !important;">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 15.5%">
                                                            <i class="fas fa-calendar-alt"></i> Purchase date
                                                            (MM/DD/YYYY):<span class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">
                                                            {{ $inventories->buy_date }}
                                                            <span class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>

                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-money-bill m-r-5"></i> Cost:
                                                            <span class="text-center"
                                                                style="white-space: normal !important;">
                                                        </td>
                                                        <td style="width: 25%">RM
                                                            {{ number_format($inventories->price, 2, '.', ',') }} <span
                                                                class="text-center" style="white-space: normal !important;">
                                                        </td>

                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-money-check m-r-5"></i> Brand: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->brand }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-store-alt"></i> Total Quantity: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->totalQuantity }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-box m-r-5"></i> Supplier Name : <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->supplierName }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-edit"></i> Registered Item: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $serialCount }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-edit"></i> Sequence No. : <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">{{ $inventories->seqNo }} <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td>
                                                        </td>
                                                        <td></td>

                                                    </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- card inventory info end --}}

                            {{-- card serial no. start --}}
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <a class="btn btn-primary btn-sm float-left"
                                                    href="{{ route('inventory.export', ['id' => $inventories->id]) }}">Export CSV
                                                </a>
                                            </div>
                                            <div class="col">
                                                <div class="col">
                                                    @if ($serialCount < $inventories->totalQuantity)
                                                        <a class="btn btn-primary btn-sm float-right"
                                                            href="{{ route('serial.create', ['id' => $inventories->id]) }}">
                                                            Add
                                                        </a>
                                                    @endif
                                                </div>
                                                <div class="col">
                                                    @if ($serialCount > 0 && $seqNo != null)
                                                        <a class="btn btn-primary btn-sm float-right"
                                                            href="{{ route('serial.generate', ['id' => $inventories->id]) }}">
                                                            Generate Tag Number
                                                        </a>
                                                    @endif
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="dt-responsive table-responsive">
                                            <table id="id=serial-table"
                                                class="table table-striped table-bordered nowrap table text-center">
                                                <thead>
                                                    <tr>
                                                        <th>No.</th>
                                                        <th>Serial Number</th>
                                                        <th>Tag Number</th>
                                                        <th>Holder</th>
                                                        <th>Location</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php $counter = 1 @endphp
                                                    @if (!$serials->isEmpty())
                                                        @foreach ($serials as $serial)
                                                            <tr>
                                                                <td class="text-center">{{ $counter++ }}</td>
                                                                <td>{{ $serial->serialNo }}</td>
                                                                <td>{{ $serial->tagNumber }}</td>
                                                                <td>{{ $serial->holder }}</td>
                                                                <td>{{ $serial->location?->name ?? 'N/A' }}</td>
                                                                <td>{{ $serial->status ?? 'Unknown' }}</td> <!-- New column data -->
                                                                <td class="col-1">
                                                                    <button type="button" class="btn btn-glow btn-info"
                                                                        onclick="window.location.href='{{ route('serial.show', ['id1' => $serial->inventory_id, 'id2' => $serial->id]) }}'">Info</button>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        <tr>
                                                            <td colspan="7" class="text-center">No Data Found</td> <!-- Updated colspan -->
                                                        </tr>
                                                    @endif
                                                </tbody>
                                                
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            {{-- card serial no. end --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        function confirmDelete() {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Delete'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('deleteForm').submit();
                }
            });
        }
    </script>
@endsection
