@extends('layouts.app')

@section('content')
<section class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">                                                      
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">Inventory Pro</h5>
                                        </div>
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item"><a href="{{ route('home') }}"><i
                                                        class="feather icon-home"></i></a></li>
                                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Inventory</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ breadcrumb ] end -->

                        {{-- table index start --}}
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col">
                                            <h5>Locations</h5>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card-body">

                                    @if ($message = Session::get('success'))
                                    <div class="alert alert-success" role="alert">
                                        {{ $message }}
                                    </div>
                                @endif

                                @if ($message = Session::get('error'))
                                    <div class="alert alert-danger" role="alert">
                                        {{ $message }}
                                    </div>
                                @endif

                                @if ($errors->any())
                                    <div class="alert alert-danger" role="alert">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                    <div class="dt-responsive table-responsive">
                                        <table id="dom-table" class="table table-striped table-bordered nowrap ">
                                            <thead>
                                                <tr>
                                                    <th>No.</th>
                                                    <th>Location</th>                                                    
                                                    <th class="col-2 text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php $counter = 1 @endphp
                                                @foreach ($locations as $location)
                                                    <tr>
                                                        <td class="col-1">{{ $counter++ }}</td>
                                                        <td>{{ $location->name }}</td>
                                                        <td class="col-2 text-center"><a href="{{ route('category.index', $location->id) }}" class="btn btn-primary btn-sm ">View</a></td>                                                       
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- table index end --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

