<!DOCTYPE html>
<html lang="en">

<head>
    <title>Inventory Management</title>
    <!-- Meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="Inventory Management System" />
    <meta name="keywords" content="inventory, management, bootstrap, admin template">
    <meta name="author" content="Phoenixcoded" />
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <!-- Favicon icon -->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
    <!-- fontawesome icon -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/fontawesome/css/fontawesome-all.min.css')); ?>">
    <!-- animation css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/animation/css/animate.min.css')); ?>">
    <!-- data tables css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/data-tables/css/datatables.min.css')); ?>">
    <!-- vendor css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">


    
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
    <!-- endinject -->
    <!-- Plugin css for this page -->
    <link rel="stylesheet" href="assets/vendors/jvectormap/jquery-jvectormap.css">
    <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="assets/vendors/owl-carousel-2/owl.carousel.min.css">
    <link rel="stylesheet" href="assets/vendors/owl-carousel-2/owl.theme.default.min.css">
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <!-- endinject -->
    <!-- Layout styles -->
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- End layout styles -->
    <link rel="shortcut icon" href="assets/images/favicon.png" />

    <!-- Include ApexCharts Library -->
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">



</head>

<body>
    <!-- Pre-loader start -->
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <!-- Pre-loader end -->

    <!-- Navigation menu start -->
    <nav class="pcoded-navbar menupos-fixed">
        <div class="navbar-wrapper">
            <div class="navbar-brand header-logo">
                <a href="<?php echo e(route('home')); ?>" class="b-brand">
                    <span class="b-title">InventPRO</span>
                </a>
            </div>
            <div class="navbar-content scroll-div">
                <ul class="nav pcoded-inner-navbar">
                    <li class="nav-item pcoded-menu-caption">
                        <label>Navigation</label>
                    </li>
                    <li>
                        <a href="<?php echo e(route('dashboard')); ?>" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">Dashboard</span></a>
                    </li>
                    <li class="nav-item pcoded-hasmenu">
                        <a href="#!" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">Inventory</span></a>
                        <ul class="pcoded-submenu">
                            <li><a href="<?php echo e(route('home')); ?>" class="">View Inventory</a></li>
                            <li><a href="<?php echo e(route('inventory.create')); ?>">Add Inventory</a></li>
                            <li><a href="<?php echo e(route('inventory.showHolder')); ?>">Holder</a></li>
                        </ul>
                    </li>
                    <li class="nav-item pcoded-hasmenu">
                        <a href="#!" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">Parameter</span></a>
                        <ul class="pcoded-submenu">
                            <li><a href="<?php echo e(route('category.create')); ?>" class="">Manage Category</a></li>
                            <li><a href="<?php echo e(route('category.create')); ?>" class="">Manage Holder</a></li>
                        </ul>
                    </li>
                    <li class="nav-item pcoded-hasmenu">
                        <a href="#!" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">Location</span></a>
                        <ul class="pcoded-submenu">
                            <li><a href="<?php echo e(route('location.create')); ?>" class="">Manage Location</a></li>
                        </ul>
                    </li>
                    <li class="nav-item pcoded-hasmenu">
                        <a href="#!" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">Report</span></a>
                        <ul class="pcoded-submenu">
                            <li><a href="<?php echo e(route('report.index')); ?>" class="">Generate Report</a></li>
                        </ul>
                    </li>
                    <li class="nav-item pcoded-hasmenu">
                        <a href="#!" class="nav-link"><span class="pcoded-micon"><i
                                    class="feather icon-map-pin"></i></span><span
                                class="pcoded-mtext">User</span></a>
                        <ul class="pcoded-submenu">
                            <li><a href="<?php echo e(route('user.index')); ?>" class="">Manage User</a></li>
                            <li><a href="<?php echo e(route('auditLog.index')); ?>" class="">Audit Trail</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Navigation menu end -->

    <!-- Header start -->
    <header class="navbar pcoded-header navbar-expand-lg navbar-light headerpos-fixed">
        <div class="m-header">
            <a class="mobile-menu" id="mobile-collapse1" href="#!"><span></span></a>
            <a href="<?php echo e(route('home')); ?>" class="b-brand">
                <div class="b-bg">
                    I
                </div>
                <span class="b-title">Inventory</span>
            </a>
        </div>
        <a class="mobile-menu" id="mobile-header" href="#!">
            <i class="feather icon-more-horizontal"></i>
        </a>
        <div class="collapse navbar-collapse">
            <ul class="navbar-nav mr-auto">
                <li>
                    <!-- Breadcrumb start -->
                    <!-- Breadcrumb end -->
                </li>
            </ul>
            <ul class="navbar-nav ml-auto">
                <li>
                    <div class="dropdown drp-user">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <i class="icon feather icon-settings"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-notification">
                            <div class="pro-head">
                                <img src="<?php echo e(asset('assets/images/user/avatar-1.jpg')); ?>" class="img-radius"
                                    alt="User-Profile-Image">
                                <span><?php echo e(Auth::user()->name); ?></span>
                            </div>
                            <ul class="pro-body">
                                <li><a href="<?php echo e(route('logout')); ?>" class="dropdown-item"><i
                                            class="feather icon-log-out"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </header>
    <!-- Header end -->

    <main class="py-4">
        <div class="container-fluid">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- Vendor JS -->
    <script src="<?php echo e(asset('assets/js/vendor-all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
    <!-- DataTables JS -->
    <script src="<?php echo e(asset('assets/plugins/data-tables/js/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/data-basic-custom.js')); ?>"></script>
    <!-- App JS -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    <!-- SweetAlert JS -->
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Script to hide loader -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var loaderBg = document.querySelector('.loader-bg');
            if (loaderBg) {
                loaderBg.style.display = 'none';
            }
        });

        $(document).ready(function() {
            // Ensure dropdown works
            $('.dropdown-toggle').dropdown();
        });
    </script>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\Inventory-System\resources\views/layouts/app.blade.php ENDPATH**/ ?>