

<?php $__env->startSection('content'); ?>
    <?php

    ?>
    <section class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ breadcrumb ] start -->
                            <div class="page-header">
                                <div class="page-block">
                                    <div class="row align-items-center">
                                        <div class="col-md-12">
                                            <div class="page-header-title">
                                                <h5 class="m-b-10">Inventory Pro</h5>
                                            </div>
                                            <ul class="breadcrumb">
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><i
                                                            class="feather icon-home"></i></a></li>

                                                <li class="breadcrumb-item"><a href="">Inventory</a></li>

                                                <li class="breadcrumb-item"><a
                                                        href=""><?php echo e($inventories->category->name); ?></a>
                                                </li>
                                                <li class="breadcrumb-item"><a href=""><?php echo e($inventoryName); ?></a></li>

                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- [ breadcrumb ] end -->

                            
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-9">
                                                <h5><?php echo e($inventoryName); ?></h5>
                                            </div>
                                            <div class="col-1.5">
                                                <form action="<?php echo e(route('inventory.destroy', ['id' => $inventories->id])); ?>"
                                                    method="POST" id="deleteForm">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" class="btn btn-danger btn-sm"
                                                        onclick="confirmDelete()">
                                                        <i class="feather icon-slash"></i> Delete
                                                    </button>
                                                </form>
                                            </div>
                                            <div class="col-1.5">
                                                <a href="<?php echo e(route('inventory.edit', ['id' => $inventories->id])); ?>"
                                                    class="btn btn-primary btn-sm">
                                                    <i class="feather icon-edit"></i> Edit
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-body task-details" style="">
                                            <table class="table" style="table-layout: fixed !important;">
                                                <tbody>
                                                    <tr>
                                                        <td style="width: 15.5%">
                                                            <i class="fas fa-calendar-alt"></i> Purchase date
                                                            (MM/DD/YYYY):<span class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%">
                                                            <?php echo e($inventories->buy_date); ?>

                                                            <span class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>

                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-money-bill m-r-5"></i> Cost:
                                                            <span class="text-center"
                                                                style="white-space: normal !important;">
                                                        </td>
                                                        <td style="width: 25%">RM
                                                            <?php echo e(number_format($inventories->price, 2, '.', ',')); ?> <span
                                                                class="text-center" style="white-space: normal !important;">
                                                        </td>

                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-money-check m-r-5"></i> Brand: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%"><?php echo e($inventories->brand); ?> <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-store-alt"></i> Total Quantity: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%"><?php echo e($inventories->totalQuantity); ?> <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-box m-r-5"></i> Supplier Name : <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%"><?php echo e($inventories->supplierName); ?> <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-edit"></i> Registered Item: <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%"><?php echo e($serialCount); ?> <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="width: 12.5%">
                                                            <i class="fas fa-edit"></i> Sequence No. : <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td style="width: 25%"><?php echo e($inventories->seqNo); ?> <span
                                                                class="text-center"
                                                                style="white-space: normal !important;"></span>
                                                        </td>
                                                        <td>
                                                        </td>
                                                        <td></td>

                                                    </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            

                            
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <a class="btn btn-primary btn-sm float-left"
                                                    href="<?php echo e(route('inventory.export', ['id' => $inventories->id])); ?>">Export CSV
                                                </a>
                                            </div>
                                            <div class="col">
                                                <div class="col">
                                                    <?php if($serialCount < $inventories->totalQuantity): ?>
                                                        <a class="btn btn-primary btn-sm float-right"
                                                            href="<?php echo e(route('serial.create', ['id' => $inventories->id])); ?>">
                                                            Add
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col">
                                                    <?php if($serialCount > 0 && $seqNo != null): ?>
                                                        <a class="btn btn-primary btn-sm float-right"
                                                            href="<?php echo e(route('serial.generate', ['id' => $inventories->id])); ?>">
                                                            Generate Tag Number
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="dt-responsive table-responsive">
                                            <table id="id=serial-table"
                                                class="table table-striped table-bordered nowrap table text-center">
                                                <thead>
                                                    <tr>
                                                        <th>No.</th>
                                                        <th>Serial Number</th>
                                                        <th>Tag Number</th>
                                                        <th>Holder</th>
                                                        <th>Location</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $counter = 1 ?>
                                                    <?php if(!$serials->isEmpty()): ?>
                                                        <?php $__currentLoopData = $serials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td class="text-center"><?php echo e($counter++); ?></td>
                                                                <td><?php echo e($serial->serialNo); ?></td>
                                                                <td><?php echo e($serial->tagNumber); ?></td>
                                                                <td><?php echo e($serial->holder); ?></td>
                                                                <td><?php echo e($serial->location?->name ?? 'N/A'); ?></td>
                                                                <td><?php echo e($serial->status ?? 'Unknown'); ?></td> <!-- New column data -->
                                                                <td class="col-1">
                                                                    <button type="button" class="btn btn-glow btn-info"
                                                                        onclick="window.location.href='<?php echo e(route('serial.show', ['id1' => $serial->inventory_id, 'id2' => $serial->id])); ?>'">Info</button>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center">No Data Found</td> <!-- Updated colspan -->
                                                        </tr>
                                                    <?php endif; ?>
                                                </tbody>
                                                
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        function confirmDelete() {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Delete'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('deleteForm').submit();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Inventory-System\resources\views/inventory/show.blade.php ENDPATH**/ ?>